---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：15-Usage Trends Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **Vueコンポーネントの詳細構造**：フロントエンドコードの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/admin/usage_trends_controller.rb` (行6-10, 12, 16)
- E-02: 帳票一覧.csv (No.15の定義)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面表示型のレポート | E-01 (コントローラ構造) | ○ |
| C-02 | /admin/usage_trendsでアクセス | E-01 (ルーティング) | ○ |
| C-03 | indexアクションは空 | E-01 (行16) | ○ |
| C-04 | track_eventでトラッキング | E-01 (行6-10) | ○ |
| C-05 | i_analytics_instance_statisticsイベント | E-01 (行7) | ○ |
| C-06 | feature_category :devops_reports | E-01 (行12) | ○ |
| C-07 | Vue.jsコンポーネントで実装 | E-01 (構造から推測) | ○ |
| C-08 | GraphQL APIを使用 | E-01 (構造から推測) | ○ |
| C-09 | analytics_usage_trends_measurementsテーブル | E-02 (構造から推測) | ○ |
| C-10 | ユーザー数の推移を表示 | E-02 | ○ |
| C-11 | プロジェクト数の推移を表示 | E-02 | ○ |
| C-12 | グループ数の推移を表示 | E-02 | ○ |
| C-13 | Issue数の推移を表示 | E-02 | ○ |
| C-14 | MR数の推移を表示 | E-02 | ○ |
| C-15 | Vueコンポーネントの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vueコンポーネントの詳細実装
  - 候補：app/assets/javascripts/analytics/usage_trends/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コントローラ実装は確認済み
- 1: 中リスク - フロントエンド実装は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] /admin/usage_trendsにアクセスして画面表示を確認
- [ ] 各トレンドグラフが表示されることを確認
- [ ] GraphQL APIが正しく呼び出されることを確認
- [ ] Vueコンポーネントのファイル構成を確認
